var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { setTimeout } from 'node:timers/promises';
import pc from 'picocolors';
export const calculateIndividualFileMetrics = (file, index, totalFiles, tokenCounter, progressCallback) => __awaiter(void 0, void 0, void 0, function* () {
    const charCount = file.content.length;
    const tokenCount = tokenCounter.countTokens(file.content, file.path);
    progressCallback(`Calculating metrics... (${index + 1}/${totalFiles}) ${pc.dim(file.path)}`);
    // Sleep for a short time to prevent blocking the event loop
    yield setTimeout(1);
    return { path: file.path, charCount, tokenCount };
});
//# sourceMappingURL=calculateIndividualFileMetrics.js.map